#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_AdministrativeDataReport  : BaseTest 
	{
		
		private BOL.AdministrativeDataReport _tstReport;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
			
			_tstReport = new BOL.AdministrativeDataReport();

			if (this.RefreshData)
			{
				this._tstReport.StartDate = DateTime.Today.AddYears(-1);
				this._tstReport.EndDate = DateTime.Today;
				this._tstReport.PrintedBy = Common.LogonUser.LogonUserName;
				this._tstReport.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
				this._tstReport.IsMultiDivisional = false;

				if (this._tstReport.GetAdministrativeDataReport().Rows.Count == 0)
				{
					bool codabarUnit = (new Random().Next(1) == 1) ? true : false;
					DataCreator.CreateBloodUnit(codabarUnit);
				}


				this.RefreshData = false;
			}
			
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			Assert.IsNotNull(this._tstReport);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}


		[Test]
		public void GetAdministrativeDataReport_Divisional_Pass()
		{
			this._tstReport.StartDate = DateTime.Today.AddYears(-1);
			this._tstReport.EndDate = DateTime.Today;
			this._tstReport.PrintedBy = Common.LogonUser.LogonUserName;
			this._tstReport.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			this._tstReport.IsMultiDivisional = false;
			
			Assert.AreEqual(true, this._tstReport.GetAdministrativeDataReport().Rows.Count > 0, "Report returns data" );
		}

		[Test]
		public void GetAdministrativeDataReport_MultiDivisional_Pass()
		{
			this._tstReport.StartDate = DateTime.Today.AddYears(-1);
			this._tstReport.EndDate = DateTime.Today;
			this._tstReport.PrintedBy  =  Common.LogonUser.LogonUserName;
			this._tstReport.DivisionCode  =  Common.LogonUser.LogonUserDivisionCode;
			this._tstReport.IsMultiDivisional = true;
			
			Assert.AreEqual(true, this._tstReport.GetAdministrativeDataReport().Rows.Count > 0, "Report returns data" );
		}

		[Test]
		public void GetAdministrativeDataReport_Fail()
		{
			this._tstReport.StartDate = DateTime.Today.AddYears(-1);
			this._tstReport.EndDate = DateTime.Today;
			this._tstReport.PrintedBy  =  Common.LogonUser.LogonUserName;
			this._tstReport.DivisionCode = "NOTVALID";
			this._tstReport.IsMultiDivisional = false;
			
			Assert.AreEqual(0, this._tstReport.GetAdministrativeDataReport().Rows.Count, "Rows.Count");
			Assert.AreEqual(string.Empty, this._tstReport.GetAdministrativeDataReport().TableName, "TableName");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//printer method -- no way to unit test
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
		}
	}
}
#endif
